<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/api.php';
require_once __DIR__ . '/layout.php';

$bookId = $_GET['id'] ?? '41000119953';
$bookId = preg_replace('/[^0-9]/', '', $bookId);

$detail = getDetail($bookId);

$drama = null;
$episodes = [];
if ($detail) {
    // Correct structure: detail info is in $detail['detail'], episodes in $detail['episodes']
    $drama    = $detail['detail'] ?? null;
    $episodes = $detail['episodes'] ?? [];
}

if (!$drama) {
    htmlHead('Drama Tidak Ditemukan');
    htmlNavbar();
    echo '<div class="page-wrapper"><div class="container"><div class="empty-state" style="margin-top:80px"><h3>Drama tidak ditemukan</h3><p>ID: '.htmlspecialchars($bookId).'</p><a href="' . getBase() . '/index.php" class="btn-red" style="margin-top:16px;display:inline-flex">Kembali ke Beranda</a></div></div></div>';
    htmlFooter(); htmlClose(); exit;
}

$title    = htmlspecialchars($drama['title'] ?? 'Untitled');
$desc     = htmlspecialchars(strip_tags($drama['introduction'] ?? ''));
$cover    = htmlspecialchars($drama['cover'] ?? '');
// Use real chapter_count from detail API (not capped by allepisode 21-ep limit)
$epCount  = ($drama['chapter_count'] ?? 0) ?: count($episodes);
// tags = array of plain strings (genre/tag dari dramabox API)
$tagList  = array_merge($drama['genres'] ?? [], $drama['tags'] ?? []);
$tagList  = array_unique($tagList);
$tagV3s   = [];
$protagonist = $drama['protagonist'] ?? '';
$rating   = $drama['rating'] ?? '';
$completed= $drama['completed'] ?? false;
// $base sudah di-set oleh config.php

// Build episodes data untuk JS
$epData = [];
foreach($episodes as $ep) {
    $epData[] = [
        'id'      => $ep['chapter_id']     ?? '',
        'num'     => $ep['episode_number'] ?? '',
        'mp4'     => $ep['video']['mp4']     ?? '',
        'mp4_hd'  => $ep['video']['mp4_hd']  ?? $ep['video']['mp4'] ?? '',
        'mp4_fhd' => $ep['video']['mp4_fhd'] ?? $ep['video']['mp4'] ?? '',
        'title'   => $ep['episode_name']   ?? ('Episode ' . ($ep['episode_number'] ?? '')),
        'is_free' => $ep['is_free']        ?? true,
        'unlock'  => $ep['unlock']         ?? false,
        'cover'   => $ep['cover']          ?? '',
        'alt'     => $ep['video']['alt']   ?? [],  // fallback URLs jika tidak ada audio
    ];
}

htmlHead($title, "<style>
.detail-hero-bg{background-image:url('" . addslashes($cover) . "');}
</style>");
htmlNavbar();
?>

<!-- TikTok-style Player -->
<div class="tiktok-player" id="tiktokPlayer">
  <div class="tiktok-player-header">
    <div>
      <div class="tiktok-player-title" id="tiktokTitle"><?= $title ?></div>
      <div class="tiktok-player-ep"><span id="tiktokEpCurrent">1</span> / <span id="tiktokEpTotal"><?= $epCount ?></span> Episode</div>
    </div>
    <button class="tiktok-close" id="tiktokClose">✕</button>
  </div>
  <div class="tiktok-video-container">
    <video id="tiktokVideo" playsinline webkit-playsinline preload="auto" controlsList="nodownload"></video>
    <div class="tiktok-overlay">
      <div class="tiktok-tap-hint">Swipe ↑↓ untuk episode berikutnya</div>
    </div>
    <div class="tiktok-side-controls">
      <button class="tiktok-side-btn" id="tiktokEpListBtn" title="Daftar Episode">
        <svg width="26" height="26" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><rect x="3" y="4" width="18" height="2" rx="1"/><rect x="3" y="11" width="18" height="2" rx="1"/><rect x="3" y="18" width="12" height="2" rx="1"/></svg>
        <span><?= $epCount ?> Ep</span>
      </button>
      <button class="tiktok-side-btn" id="tiktokDownloadBtn" onclick="downloadCurrentEp()" title="Download">
        <svg width="26" height="26" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M21 15v4a2 2 0 01-2 2H5a2 2 0 01-2-2v-4"/><polyline points="7 10 12 15 17 10"/><line x1="12" y1="15" x2="12" y2="3"/></svg>
        <span>Unduh</span>
      </button>
      <button class="tiktok-side-btn" onclick="BonifixPlayer.prev()">
        <svg width="26" height="26" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><polyline points="15 18 9 12 15 6"/></svg>
        <span>Prev</span>
      </button>
      <button class="tiktok-side-btn" onclick="BonifixPlayer.next()">
        <svg width="26" height="26" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><polyline points="9 18 15 12 9 6"/></svg>
        <span>Next</span>
      </button>
    </div>
    <div class="tiktok-ep-bottom">
      <span class="ep-cur">Ep <span id="tiktokEpCurrentBottom">1</span></span>
      <span class="ep-info">/ <?= $epCount ?></span>
    </div>
    <div class="tiktok-progress">
      <div class="tiktok-progress-bar" id="tiktokProgressBar">
        <div class="tiktok-progress-fill" id="tiktokProgressFill"></div>
      </div>
    </div>
  </div>
  <!-- Next episode overlay -->
  <div id="nextEpOverlay" style="display:none;position:absolute;bottom:80px;right:16px;background:rgba(20,20,20,0.95);border:1px solid #333;border-radius:12px;padding:14px;text-align:center;z-index:30;min-width:180px;">
    <div style="font-size:0.82rem;color:#b3b3b3;margin-bottom:6px;">Episode berikutnya dalam</div>
    <div id="nextCountdown" style="font-size:2rem;font-weight:900;color:var(--netflix-red);">5</div>
    <div style="display:flex;gap:8px;margin-top:10px;">
      <button id="nextEpBtn" class="btn-red btn-sm" style="flex:1">Lanjut ▶</button>
      <button id="cancelNextBtn" class="btn-outline btn-sm" style="flex:1">Batal</button>
    </div>
  </div>
</div>

<!-- Drama Hero -->
<div class="detail-hero" style="padding-top: var(--navbar-h)">
  <div class="detail-hero-bg"></div>
  <div class="detail-content">
    <div class="detail-poster animate-in">
      <img src="<?= $cover ?>" alt="<?= $title ?>" onerror="this.src='https://via.placeholder.com/200x300/1a1a1a/555?text=No+Image'">
    </div>
    <div class="detail-info animate-in animate-delay-1">
      <?php if (!empty($tagList)): ?>
      <div class="detail-genre-tags">
        <?php foreach(array_slice($tagList, 0, 5) as $tag): ?>
        <span class="genre-tag"><?= htmlspecialchars((string)$tag) ?></span>
        <?php endforeach; ?>
      </div>
      <?php endif; ?>
      <h1 class="detail-title"><?= $title ?></h1>
      <div class="detail-meta">
        <?php if($epCount): ?><span class="ep-count"><?= $epCount ?> Episode</span><?php endif; ?>
        <?php if($completed): ?><span style="color:#46d369">● Selesai</span><?php else: ?><span style="color:#f5c518">● Ongoing</span><?php endif; ?>
        <?php if($rating): ?><span style="color:#f5c518">🔥 <?= htmlspecialchars($rating) ?></span><?php endif; ?>
        <?php if($protagonist): ?><span>🎭 <?= htmlspecialchars(is_array($protagonist) ? implode(', ', $protagonist) : $protagonist) ?></span><?php endif; ?>
      </div>
      <?php if($desc): ?>
      <p class="detail-desc"><?= substr($desc, 0, 300) . (strlen($desc) > 300 ? '...' : '') ?></p>
      <?php endif; ?>
      <div class="detail-actions">
        <?php if (!empty($episodes)): 
          $firstMp4 = $episodes[0]['video']['mp4'] ?? '';
        ?>
        <button class="btn-play" onclick="openPlayer(0)">
          <svg width="18" height="18" fill="currentColor" viewBox="0 0 24 24"><polygon points="5 3 19 12 5 21 5 3"/></svg>
          Putar Ep 1
        </button>
        <button class="btn-info" onclick="document.getElementById('episodesSection').scrollIntoView({behavior:'smooth'})">
          <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><rect x="3" y="4" width="18" height="2" rx="1"/><rect x="3" y="11" width="18" height="2" rx="1"/><rect x="3" y="18" width="12" height="2" rx="1"/></svg>
          <?= $epCount ?> Episode
        </button>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<!-- Desktop Video Player -->
<div class="video-section" id="desktopVideoSection" style="display:none">
  <div class="video-player-wrapper">
    <video id="desktopVideo" controls playsinline controlsList="nodownload" style="width:100%;height:100%"></video>
  </div>
  <div class="video-info-bar">
    <div>
      <div class="video-ep-title" id="currentEpLabel">Episode 1</div>
      <div class="video-ep-sub"><?= $title ?></div>
    </div>
    <div class="video-controls">
      <button class="btn-outline btn-sm" id="prevEpDesktop" onclick="navigateEp(-1)">‹ Prev</button>
      <button class="btn-outline btn-sm" id="downloadEpDesktop" onclick="downloadCurrentEp()">
        <svg width="14" height="14" fill="none" stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24" style="vertical-align:-2px"><path d="M21 15v4a2 2 0 01-2 2H5a2 2 0 01-2-2v-4"/><polyline points="7 10 12 15 17 10"/><line x1="12" y1="15" x2="12" y2="3"/></svg>
        Unduh
      </button>
      <button class="btn-outline btn-sm" id="nextEpDesktop" onclick="navigateEp(1)">Next ›</button>
    </div>
  </div>
  <div style="height:4px;background:#222;border-radius:2px;margin-top:4px;overflow:hidden">
    <div id="desktopProgress" style="height:100%;background:var(--netflix-red);width:0%;transition:width 0.3s linear"></div>
  </div>
</div>

<!-- Episodes Section -->
<div class="episodes-section container" id="episodesSection">
  <div class="episodes-header animate-in">
    <div>
      <h2 class="section-title">Daftar Episode</h2>
      <p style="color:var(--text-gray);font-size:0.85rem;margin-top:4px"><?= $title ?></p>
    </div>
    <div style="display:flex;align-items:center;gap:10px">
      <span class="ep-count-badge"><?= $epCount ?> Episode</span>
    </div>
  </div>

  <div class="episodes-grid animate-in" id="episodesGrid">
    <?php foreach($episodes as $i => $ep):
      $epNum   = $ep['episode_number'] ?? ($i + 1);
      $epTitle = htmlspecialchars($ep['episode_name'] ?? 'Episode ' . $epNum);
      $hasVideo = !empty($ep['video']['mp4']) || !empty($ep['video']['m3u8']);
      $isLocked = !$hasVideo && empty($ep['is_free']);
    ?>
    <div class="ep-card<?= $isLocked ? ' ep-locked' : '' ?>" data-ep-index="<?= $i ?>">
      <div class="ep-card-inner" onclick="openPlayer(<?= $i ?>)">
        <div class="ep-num"><?= $epNum ?></div>
        <div class="ep-label"><?= $isLocked ? '🔒' : 'Episode' ?></div>
      </div>
      <div class="ep-play-icon" onclick="openPlayer(<?= $i ?>)"><?= $isLocked ? '🔒' : '▶' ?></div>
      <?php if ($hasVideo): ?>
      <button class="ep-download-btn" onclick="event.stopPropagation();downloadEp(<?= $i ?>)" title="Download Episode <?= $epNum ?>">
        <svg width="14" height="14" fill="none" stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24"><path d="M21 15v4a2 2 0 01-2 2H5a2 2 0 01-2-2v-4"/><polyline points="7 10 12 15 17 10"/><line x1="12" y1="15" x2="12" y2="3"/></svg>
      </button>
      <?php endif; ?>
    </div>
    <?php endforeach; ?>
  </div>
</div>

<script>
var episodesData = <?= json_encode($epData) ?>;
var dramaTitle = <?= json_encode($title) ?>;
var dramaBooksId = <?= json_encode($bookId) ?>;
var dramaChapterCount = <?= json_encode((int)($drama['chapter_count'] ?? count($episodes))) ?>;
var currentDesktopEp = 0;
var isMobile = window.innerWidth <= 768;

// Simpan ke riwayat tontonan (localStorage, max 10)
(function() {
  if (typeof WatchHistory !== 'undefined') {
    WatchHistory.save({
      id:    <?= json_encode($bookId) ?>,
      title: <?= json_encode($drama['title'] ?? '') ?>,
      cover: <?= json_encode($drama['cover'] ?? '') ?>,
      ep:    <?= json_encode((string)$epCount) ?>,
    });
  } else {
    // fallback: run after app.js is loaded
    window.addEventListener('load', function() {
      if (typeof WatchHistory !== 'undefined') {
        WatchHistory.save({
          id:    <?= json_encode($bookId) ?>,
          title: <?= json_encode($drama['title'] ?? '') ?>,
          cover: <?= json_encode($drama['cover'] ?? '') ?>,
          ep:    <?= json_encode((string)$epCount) ?>,
        });
      }
    });
  }
})();

// Lazy-fetch URL video untuk episode yang mp4-nya kosong
// Menggunakan episode-fetch.php (server-side: cover-trick + megawe fallback)
var fetchingEp = {};

function fetchVideoUrl(epIdx, callback) {
  var ep = episodesData[epIdx];
  if (!ep) return callback(null);
  var url = ep.mp4_hd || ep.mp4 || ep.mp4_fhd || '';
  if (url) return callback(url);

  if (fetchingEp[epIdx]) {
    var wait = setInterval(function(){
      if (!fetchingEp[epIdx]) {
        clearInterval(wait);
        callback(episodesData[epIdx].mp4_hd || episodesData[epIdx].mp4 || episodesData[epIdx].mp4_fhd || null);
      }
    }, 200);
    return;
  }
  fetchingEp[epIdx] = true;

  // Gunakan episode-fetch.php (server-side) — support chapterId DAN epIndex
  var fetchUrl = '<?= $base ?>/episode-fetch.php?bookId=' + dramaBooksId;
  if (ep.id) {
    fetchUrl += '&chapterId=' + ep.id;
  }
  fetchUrl += '&epIndex=' + epIdx;  // selalu kirim epIndex sebagai fallback

  fetch(fetchUrl)
  .then(function(r){ return r.json(); })
  .then(function(d){
    fetchingEp[epIdx] = false;
    if (d && d.success) {
      var best = d.mp4 || d.m3u8 || '';
      if (best) {
        episodesData[epIdx].mp4    = best;
        episodesData[epIdx].mp4_hd = best;
        episodesData[epIdx].mp4_fhd= best;
        // Simpan alt URLs juga
        if (d.alt && d.alt.length) {
          episodesData[epIdx].alt = (episodesData[epIdx].alt || []).concat(d.alt);
        }
        callback(best);
        return;
      }
    }
    // Fallback: langsung ke megawe (last resort)
    fetch('https://api.megawe.net/api/dramabox/allepisode?bookId=' + dramaBooksId + '&lang=in')
    .then(function(r2){ return r2.json(); })
    .then(function(d2){
      var eps = (d2 && d2.data) ? d2.data : [];
      eps.forEach(function(ep2, i) {
        var paths = (ep2.cdnList && ep2.cdnList[0] && ep2.cdnList[0].videoPathList) ? ep2.cdnList[0].videoPathList : [];
        var mp4 = '', hd = '';
        paths.forEach(function(p){
          if (p.quality >= 1080 && !hd) hd = p.videoPath;
          else if (p.quality >= 720 && !mp4) mp4 = p.videoPath;
        });
        var best2 = mp4 || hd || (paths[0] ? paths[0].videoPath : '');
        if (best2 && episodesData[i]) {
          var proxy = '<?= $base ?>/video-proxy.php?url=' + encodeURIComponent(best2);
          episodesData[i].mp4    = proxy;
          episodesData[i].mp4_hd = proxy;
          episodesData[i].mp4_fhd= proxy;
        }
      });
      var updated = episodesData[epIdx];
      callback(updated ? (updated.mp4_hd || updated.mp4 || null) : null);
    })
    .catch(function(){ callback(null); });
  })
  .catch(function(){
    fetchingEp[epIdx] = false;
    callback(null);
  });
}

/**
 * Coba putar video — jika gagal (tidak ada audio / error) coba URL alternatif.
 * @param {HTMLVideoElement} videoEl
 * @param {string[]} urls  - array URL untuk dicoba berurutan
 * @param {Function} onSuccess - callback(url) ketika berhasil
 * @param {Function} onFail    - callback() jika semua gagal
 */
function tryPlayUrls(videoEl, urls, onSuccess, onFail) {
  if (!urls || !urls.length) return onFail && onFail();
  var idx = 0;
  function attempt() {
    if (idx >= urls.length) return onFail && onFail();
    var url = urls[idx++];
    if (!url) return attempt();
    videoEl.src = url;
    videoEl.load();
    var played = false;
    var onCanPlay = function() {
      cleanup();
      if (!played) { played = true; videoEl.play().catch(function(){}); onSuccess && onSuccess(url); }
    };
    var onError = function() {
      cleanup();
      attempt(); // coba URL berikutnya
    };
    var cleanup = function() {
      videoEl.removeEventListener('canplay', onCanPlay);
      videoEl.removeEventListener('error', onError);
    };
    videoEl.addEventListener('canplay', onCanPlay);
    videoEl.addEventListener('error', onError);
  }
  attempt();
}

function openPlayer(idx) {
  var ep = episodesData[idx];
  if (!ep) return;
  currentDesktopEp = idx;

  // Update riwayat: catat episode terakhir yang ditonton
  if (typeof WatchHistory !== 'undefined') {
    WatchHistory.save({
      id:     dramaBooksId,
      title:  dramaTitle,
      cover:  episodesData[0] ? (episodesData[0].cover || '') : '',
      ep:     String(episodesData.length),
      lastEp: idx + 1,
    });
  }

  // Kumpulkan semua URL untuk dicoba (utama + alt fallback)
  var primaryUrl = ep.mp4_hd || ep.mp4 || ep.mp4_fhd || '';
  var altUrls    = ep.alt || [];
  var allUrls    = primaryUrl ? [primaryUrl].concat(altUrls) : altUrls;

  if (window.innerWidth <= 768) {
    // Mobile: TikTok player
    if (allUrls.length) {
      if (window.BonifixPlayer && episodesData.length) {
        window.BonifixPlayer.open(episodesData, idx, dramaTitle);
        var bot = document.getElementById('tiktokEpCurrentBottom');
        if (bot) bot.textContent = idx + 1;
      }
    } else {
      // Fetch dulu lalu play
      var vid = document.getElementById('tiktokVideo');
      if (vid) { vid.poster = ep.cover || ''; }
      fetchVideoUrl(idx, function(fetchedUrl){
        if (!fetchedUrl) {
          alert('Video episode ini belum tersedia.');
          return;
        }
        if (window.BonifixPlayer) {
          window.BonifixPlayer.open(episodesData, idx, dramaTitle);
          var bot = document.getElementById('tiktokEpCurrentBottom');
          if (bot) bot.textContent = idx + 1;
        }
      });
    }
  } else {
    // Desktop player
    var section = document.getElementById('desktopVideoSection');
    if (section) section.style.display = 'block';

    var lbl = document.getElementById('currentEpLabel');
    var vid = document.getElementById('desktopVideo');

    if (allUrls.length) {
      if (lbl) lbl.textContent = 'Episode ' + (ep.num || (idx+1));
      section.scrollIntoView({behavior:'smooth', block:'start'});
      // Coba semua URL dengan audio-fallback
      tryPlayUrls(vid, allUrls,
        function(goodUrl) {
          // Berhasil — simpan URL yang valid
          episodesData[idx].mp4    = goodUrl;
          episodesData[idx].mp4_hd = goodUrl;
          episodesData[idx].mp4_fhd= goodUrl;
          if (lbl) lbl.textContent = 'Episode ' + (ep.num || (idx+1));
          updateDesktopProgress(vid, idx);
        },
        function() {
          // Semua gagal — fetch dari server
          if (lbl) lbl.textContent = 'Memuat Episode ' + (ep.num || (idx+1)) + '...';
          fetchVideoUrl(idx, function(fetchedUrl){
            if (!fetchedUrl) {
              if (lbl) lbl.textContent = 'Video tidak tersedia';
              showToast('Video episode ini belum tersedia.', 'error');
              return;
            }
            window.desktopPlay(fetchedUrl, idx);
          });
        }
      );
    } else {
      // Tidak ada URL sama sekali — tampilkan loading
      if (vid) { vid.poster = ep.cover || ''; vid.src = ''; }
      if (lbl) lbl.textContent = 'Memuat Episode ' + (ep.num || (idx+1)) + '...';
      section.scrollIntoView({behavior:'smooth', block:'start'});

      fetchVideoUrl(idx, function(fetchedUrl){
        if (!fetchedUrl) {
          if (lbl) lbl.textContent = 'Video tidak tersedia';
          showToast('Video episode ini belum tersedia.', 'error');
          return;
        }
        window.desktopPlay(fetchedUrl, idx);
      });
    }
  }
}

function navigateEp(dir) {
  var next = currentDesktopEp + dir;
  if(next >= 0 && next < episodesData.length) openPlayer(next);
}

function updateDesktopProgress(vid, idx) {
  document.querySelectorAll('.ep-card').forEach(function(c, i){ c.classList.toggle('active', i === idx); });
  var lbl = document.getElementById('currentEpLabel');
  if (lbl) lbl.textContent = 'Episode ' + (episodesData[idx] ? (episodesData[idx].num || (idx+1)) : (idx+1));
}

// Sync tiktok bottom ep display
var origLoad = window.BonifixPlayer ? window.BonifixPlayer.loadEpisode : null;
// watch tiktok ep current via MutationObserver
var epCurEl = document.getElementById('tiktokEpCurrent');
var epBotEl = document.getElementById('tiktokEpCurrentBottom');
if(epCurEl && epBotEl) {
  var obs = new MutationObserver(function(){
    epBotEl.textContent = epCurEl.textContent;
  });
  obs.observe(epCurEl, {childList:true, characterData:true, subtree:true});
}

// ===== Download Functions =====
function getVideoUrl(epIdx) {
  var ep = episodesData[epIdx];
  if (!ep) return '';
  return ep.mp4_hd || ep.mp4 || ep.mp4_fhd || '';
}

function downloadEp(epIdx) {
  var ep = episodesData[epIdx];
  if (!ep) return;
  var url = getVideoUrl(epIdx);
  if (!url) {
    showToast('Video belum tersedia untuk diunduh', 'error');
    return;
  }
  // Buat slug dari judul drama
  var slug = dramaTitle.replace(/[^a-zA-Z0-9]+/g, '-').toLowerCase().replace(/^-|-$/g, '');
  var filename = slug + '-ep' + (ep.num || (epIdx+1)) + '.mp4';
  // Buka download via blob fetch melalui proxy
  showToast('Memulai unduhan Episode ' + (ep.num || (epIdx+1)) + '...', 'info');
  var a = document.createElement('a');
  a.href = url;
  a.download = filename;
  a.target = '_blank';
  a.rel = 'noopener';
  // Coba fetch blob dulu untuk force download
  fetch(url).then(function(r) {
    if (!r.ok) throw new Error('HTTP ' + r.status);
    return r.blob();
  }).then(function(blob) {
    var blobUrl = URL.createObjectURL(blob);
    a.href = blobUrl;
    document.body.appendChild(a);
    a.click();
    setTimeout(function(){ URL.revokeObjectURL(blobUrl); a.remove(); }, 5000);
    showToast('Unduhan Episode ' + (ep.num || (epIdx+1)) + ' dimulai!', 'success');
  }).catch(function() {
    // Fallback: direct link open
    document.body.appendChild(a);
    a.click();
    a.remove();
    showToast('Mengunduh Episode ' + (ep.num || (epIdx+1)) + '...', 'info');
  });
}

function downloadCurrentEp() {
  downloadEp(currentDesktopEp);
}
</script>

<?php htmlFooter(); htmlClose(); ?>
